/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.autoplot.ExportDataFormatPanel;
import org.autoplot.jythonsupport.Util;
import org.autoplot.jythonsupport.ui.NamedURIListTool;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.QDataSetTableModel;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public final class ExportDataBundle
extends JPanel {
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.export");
    boolean updating = false;
    QDataSet bundle = null;
    private ExportDataFormatPanel exportDataFormatPanel1;
    private JButton jButton1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JTable jTable1;
    private NamedURIListTool namedURIListTool1;

    public ExportDataBundle() {
        this.initComponents();
        this.namedURIListTool1.setShowIds(false);
        this.refresh();
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.namedURIListTool1 = new NamedURIListTool();
        this.exportDataFormatPanel1 = new ExportDataFormatPanel();
        this.jSplitPane1.setOrientation(0);
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jSplitPane1.setRightComponent(this.jScrollPane1);
        this.jButton1.setText("Load");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportDataBundle.this.jButton1ActionPerformed(evt);
            }
        });
        this.namedURIListTool1.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ExportDataBundle.this.namedURIListTool1PropertyChange(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent((Component)this.namedURIListTool1, -1, 571, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1, -2, 88, -2).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButton1, -2, 65, -2).addContainerGap(-1, Short.MAX_VALUE)).addComponent((Component)this.namedURIListTool1, -1, -1, Short.MAX_VALUE));
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, GroupLayout.Alignment.TRAILING));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 446, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.exportDataFormatPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exportDataFormatPanel1, -2, 153, -2)));
    }

    private void namedURIListTool1PropertyChange(PropertyChangeEvent evt) {
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ExportDataBundle.this.refresh();
                ExportDataBundle.this.updating = false;
                ExportDataBundle.this.jButton1.setEnabled(true);
            }
        };
        if (this.updating) {
            logger.fine("already updating");
        } else {
            this.jButton1.setEnabled(false);
            this.updating = true;
            new Thread(run).start();
        }
    }

    private ProgressMonitor createProgressMonitor() {
        NullProgressMonitor result = new NullProgressMonitor();
        Timer t = new Timer(100, new ActionListener((ProgressMonitor)result){
            final /* synthetic */ ProgressMonitor val$result;
            {
                this.val$result = progressMonitor;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportDataBundle.this.jButton1.setText(this.val$result.getTaskProgress() + "/" + this.val$result.getTaskSize());
                if (this.val$result.isFinished() || this.val$result.isCancelled()) {
                    ((Timer)e.getSource()).stop();
                    ExportDataBundle.this.jButton1.setText("Load");
                }
            }
        });
        t.setRepeats(true);
        t.start();
        return result;
    }

    private void updateDataSet() {
        String[] ids = this.namedURIListTool1.getIds();
        String[] uris = this.namedURIListTool1.getUris();
        QDataSet[] dss = new QDataSet[ids.length];
        QDataSet bundle = null;
        try {
            List dssa = Util.getDataSets(Arrays.asList(uris), (ProgressMonitor)this.createProgressMonitor());
            dss = dssa.toArray(dss);
            if (dss.length > 0) {
                dssa = Ops.synchronizeNN((QDataSet)((QDataSet)dssa.get(0)), (QDataSet[])dss);
                bundle = Ops.bundle((QDataSet)((QDataSet)((QDataSet)dssa.get(0)).property("DEPEND_0")));
                block6: for (int i = 0; i < dssa.size(); ++i) {
                    QDataSet ds1 = (QDataSet)dssa.get(i);
                    switch (ds1.rank()) {
                        case 1: {
                            bundle = Ops.bundle((QDataSet)bundle, (QDataSet)((QDataSet)dssa.get(i)));
                            continue block6;
                        }
                        case 2: {
                            for (int j = 0; j < ds1.length(0); ++j) {
                                bundle = Ops.bundle((QDataSet)bundle, (QDataSet)Ops.slice1((QDataSet)ds1, (int)j));
                            }
                            continue block6;
                        }
                        default: {
                            logger.warning("unable to use data, rank is not 1 or 2");
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        this.bundle = bundle;
    }

    public QDataSet getDataSet() {
        if (this.bundle == null) {
            this.updateDataSet();
        }
        return this.bundle;
    }

    public void setUris(String[] uris) {
        this.namedURIListTool1.setUris(Arrays.asList(uris));
        String[] ids = new String[uris.length];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = "ds" + i;
        }
        this.namedURIListTool1.setIds(Arrays.asList(ids));
    }

    public String getUri() {
        return this.exportDataFormatPanel1.getURI();
    }

    public void refresh() {
        this.updateDataSet();
        QDataSet lbundle = this.getDataSet();
        if (lbundle == null) {
            DefaultTableModel n = new DefaultTableModel(1, 1);
            n.setValueAt("No Data", 0, 0);
            this.jTable1.setModel(n);
            this.exportDataFormatPanel1.setDataSet(null);
            this.exportDataFormatPanel1.setEnabled(true);
        } else {
            QDataSetTableModel tm = new QDataSetTableModel(lbundle);
            this.exportDataFormatPanel1.setDataSet(lbundle);
            this.exportDataFormatPanel1.setEnabled(true);
            this.jTable1.setModel((TableModel)tm);
            this.jTable1.getTableHeader().addMouseListener(tm.getTableHeaderMouseListener(this.jTable1));
        }
    }

    public static void main(String[] args) {
        ExportDataBundle x = new ExportDataBundle();
        JOptionPane.showMessageDialog(null, x);
    }
}

